#==============================================================================
#  Scene_Title#main
#------------------------------------------------------------------------------
# cpp^Cgʂ̏sNXłB
# Copyright (C) 2005 fukuyama
#==============================================================================

class Scene_Title
  # f[^x[X[h
  def load_database
    # {f[^
    $data_actors        = load_data("Data/Actors.rxdata")
    $data_classes       = load_data("Data/Classes.rxdata")
    $data_skills        = load_data("Data/Skills.rxdata")
    $data_items         = load_data("Data/Items.rxdata")
    $data_weapons       = load_data("Data/Weapons.rxdata")
    $data_armors        = load_data("Data/Armors.rxdata")
    $data_enemies       = load_data("Data/Enemies.rxdata")
    $data_troops        = load_data("Data/Troops.rxdata")
    $data_states        = load_data("Data/States.rxdata")
    $data_animations    = load_data("Data/Animations.rxdata")
    $data_tilesets      = load_data("Data/Tilesets.rxdata")
    $data_common_events = load_data("Data/CommonEvents.rxdata")
    $data_system        = load_data("Data/System.rxdata")
    # j[pOvpeB
    Properties_Interface_Module.load_properties($data_items,'id','Data/MenuLogItems.rxdata')
    Properties_Interface_Module.load_properties($data_skills,'id','Data/MenuLogSkills.rxdata')
    # 퓬pANVOvpeB
    Properties_Interface_Module.load_properties($data_states,'id','Data/ActionLogStatus.rxdata')
    Properties_Interface_Module.load_properties($data_skills,'id','Data/ActionLogSkills.rxdata')
    Properties_Interface_Module.load_properties($data_items,'id','Data/ActionLogItems.rxdata')
    # ACehvpeB
    Properties_Interface_Module.load_properties($data_items,'id','Data/ItemProperties.rxdata')
    Properties_Interface_Module.load_properties($data_weapons,'id','Data/WeaponsProperties.rxdata')
    Properties_Interface_Module.load_properties($data_armors,'id','Data/ArmorsProperties.rxdata')
    # Q[AN^[vpeB
    Properties_Interface_Module.load_properties($data_actors,'id','Data/ActorsProperties.rxdata')
    # Q[Gl~[vpeB
    Properties_Interface_Module.load_properties($data_enemies,'id','Data/EnemiesProperties.rxdata')
    # NXvpeB
    Properties_Interface_Module.load_properties($data_classes,'id','Data/ClassesProperties.rxdata')
  end

  #--------------------------------------------------------------------------
  #  C
  #--------------------------------------------------------------------------
  def main
    # 퓬eXg̏ꍇ
    if $BTEST
      battle_test
      return
    end
    # f[^x[X[h
    load_database
    # VXeIuWFNg쐬
    $game_system = Game_System.new
    # ^CgOtBbN쐬
    @sprite = Sprite.new
    @sprite.bitmap = RPG::Cache.title($data_system.title_name)
    # ^Cg BGM t
    $game_system.bgm_play($data_system.title_bgm)
    # MEABGS ̉t~
    Audio.me_stop
    Audio.bgs_stop
    # gWVs
    Graphics.transition(8)
    # C[v
    loop do
      # Q[ʂXV
      Graphics.update
      # ͏XV
      Input.update
      # t[XV
      update
      # ʂ؂ւ烋[v𒆒f
      if $scene != self
        break
      end
    end
    # gWV
    Graphics.freeze
    # ^CgOtBbN
    @sprite.bitmap.dispose
    @sprite.dispose
  end

  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    # ^Cg{^ꂽꍇ
    if ::DQ::DEFAULT_TITLE_MENU_KEY.any? {|k|Input.trigger?(k)}
      $scene = DQ::Scene_Title.new
    end
  end
end
